/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.runtime;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class ModDamageMitigationEventsHandler {
    private static final int _DOUSING_CHECK_MODULO = 4 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    private static final int _EFFECTS_CHECK_MODULO = 1 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();

    private int isProtecting(EntityPlayer player, boolean cold) {
        int n = 0;
        for (ItemStack armor : player.func_184193_aE()) {
            Armory.XLining.Def liningd = Armory.getXLining((ItemStack)armor);
            if (cold) {
                if (liningd.name != Armory.XLining.ANTIFREEZE_SHIELD) continue;
                ++n;
                continue;
            }
            if (liningd.name != Armory.XLining.OBSIDIAN_SHIELD) continue;
            ++n;
        }
        return n;
    }

    private boolean isHeatRelated(DamageSource what) {
        if (Armory.isDamageAbsolute((DamageSource)what)) {
            return false;
        }
        return what.func_76347_k() || what.func_94541_c() || what == SharedGlue.DamageSource_lightingBolt || what == SharedGlue.DamageSource_dragonBreath;
    }

    @SubscribeEvent
    public void onPlayerProtectedByObsidianShielding(LivingDamageEvent event) {
        EntityPlayer player = SharedGlue.getRealPlayerOrNull((Entity)event.getEntity());
        if (player == null || SharedGlue.isaClientWorld((IBlockAccess)player.func_130014_f_())) {
            return;
        }
        DamageSource what = event.getSource();
        int pieces = 0;
        if (this.isHeatRelated(what) && (pieces = this.isProtecting(player, false)) > 0) {
            float amount = event.getAmount();
            if (pieces > 3 || pieces == 3 && amount <= 1.0f) {
                event.setCanceled(true);
            } else {
                float nullified = event.getAmount() * ((float)pieces / 4.0f);
                event.setAmount(event.getAmount() - nullified);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerDousedByFireproofShielding(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player = SharedGlue.getRealPlayerOrNull((Entity)event.getEntity());
        if (player == null || player.func_70644_a(SharedGlue.Potion_fireResistance)) {
            return;
        }
        if (player.field_70173_aa % _DOUSING_CHECK_MODULO == 0 && player.func_70027_ad() && !player.func_180799_ab() && (Armory.hasXLining((Armory.XLining)Armory.XLining.OBSIDIAN_SHIELD, (ItemStack)player.func_184582_a(EntityEquipmentSlot.CHEST)) || Armory.hasXLining((Armory.XLining)Armory.XLining.OBSIDIAN_SHIELD, (ItemStack)player.func_184582_a(EntityEquipmentSlot.LEGS)))) {
            player.func_70066_B();
            Effects.playExtinguishedBurning((World)player.func_130014_f_(), (EntityPlayer)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerProtectedByAntifreezeShielding(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player = SharedGlue.getRealPlayerOrNull((Entity)event.getEntity());
        if (player == null || SharedGlue.isaClientWorld((IBlockAccess)player.func_130014_f_())) {
            return;
        }
        if (player.field_70173_aa % _EFFECTS_CHECK_MODULO == 0 && SharedGlue.hasPotionsInEffect((EntityLivingBase)player)) {
            int pieces = 0;
            pieces = this.isProtecting(player, true);
            if (pieces > 0 && (pieces > 3 || player.func_70681_au().nextFloat() < (float)pieces * 0.25f)) {
                Potions.cureFreezingEffects((EntityPlayer)player, (boolean)true);
            }
        }
    }
}

